/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

define(['backbone', 'parser'],
    function (Backbone, parser) {
        'use strict';

        var UserSession,
            singleInstance;

        UserSession = Backbone.Model.extend({
            initialize: function () {
                _.bindAll(this);
            },
            isAuthenticated: function () {
                var authenticated = false;
                if (this.get('displayName') !== undefined) {
                    authenticated = true;
                }
                return authenticated;
            },
            flattenLinks: function() {
                parser.flattenLinks(this);
            }
        });

        UserSession.instance = function () {
            if (singleInstance === undefined) {
                singleInstance = new UserSession();
            }
            return singleInstance;
        };

        return UserSession;
    });